# 抗日游击战争的战略问题  
（一九三八年五月）  
  
> 抗日战争初期，中国共产党内和党外都有许多人轻视游击战争的重大战略作用，而只把自己的希望寄托于正规战争，特别是国民党军队的作战。毛泽东批驳了这种观点，同时写了这篇文章，指出抗日游击战争发展的正确道路。其结果，在抗日时期内，在一九三七年只有四万余人的八路军和新四军，到一九四五年日本投降时就发展成为一百多万人的大军，并创建了许多革命根据地，在抗日战争中起了伟大的作用，使蒋介石在抗日时期既不敢投降日本，又不敢发动全国规模的内战，而到一九四六年发动全国规模的内战时，由八路军新四军编成的人民解放军就有力量对付蒋介石的进攻了。   
  
## 第一章　为什么提起游击战争的战略问题  

  
　　抗日战争中，正规战争是主要的，游击战争是辅助的。这一点，我们已经正确地解决了。那末，游击战争就只有战术问题，为什么提起战略问题呢？   
　　如果我们是一个小国，游击战争只是在正规军的战役作战上起些近距离的直接的配合作用，那就当然只有战术问题，没有什么战略问题。又如果中国也像苏联那样的强大，敌人进来，很快就能赶出，或虽时间较久，但是被占地区不广，游击战争也只是一种战役的配合作用，当然也只有战术问题，没有什么战略问题。   
　　游击战争的战略问题是在这样的情况之下发生的：中国既不是小国，又不像苏联，是一个大而弱的国家。这一个大而弱的国家被另一个小而强的国家所攻击，但是这个大而弱的国家却处于进步的时代，全部问题就从这里发生了。在这样的情况下，敌人占地甚广的现象发生了，战争的长期性发生了。敌人在我们这个大国中占地甚广，但他们的国家是小国，兵力不足，在占领区留了很多空虚的地方，因此抗日游击战争就主要地不是在内线配合正规军的战役作战，而是在外线单独作战；并且由于中国的进步，就是说有共产党领导的坚强的军队和广大的人民群众存在，因此抗日游击战争就不是小规模的，而是大规模的；于是战略防御和战略进攻等等一全套的东西都发生了。战争的长期性，随之也是残酷性，规定了游击战争不能不做许多异乎寻常的事情，于是根据地的问题、向运动战发展的问题等等也发生了。于是中国抗日的游击战争，就从战术范围跑了出来向战略敲门，要求把游击战争的问题放在战略的观点上加以考察。特别值得注意的，是这样又广大又持久的游击战争，在整个人类的战争史中，都是颇为新鲜的事情。这件事是同时代进步到二十世纪的三四十年代一事分不开的，是同共产党和红军的存在分不开的，这乃是问题的焦点所在。我们的敌人大概还在那里做元朝灭宋、清朝灭明、英占北美和印度、拉丁系国家占中南美等等的好梦。这等梦在今天的中国已经没有现实的价值，因为今天的中国比之上述历史多了一些东西，颇为新鲜的游击战争就是其中的一点。假如我们的敌人少估计了这一点，他们就一定要在这一点上面触一个很大的霉头。   
　　这就是抗日游击战争虽然在整个抗日战争中仍然处于辅助的地位，但是必须放在战略观点上加以考察的理由。   
　　那末，为什么不将抗日战争的一般战略问题中的东西用之于游击战争呢？   
　　抗日游击战争的战略问题，本来是密切地联系于整个抗日战争的战略问题的，许多东西二者都是一致的。然而游击战争又区别于正规战争，它本身有其特殊性，因而游击战争的战略问题颇有许多特殊的东西；抗日战争的一般战略问题中的东西，决不能照样用之于特殊情形的游击战争。   
## 第二章　战争的基本原则是保存自己消灭敌人  

  
　　在具体地说到游击战争的战略问题之先，还要说一说战争的基本问题。   
　　一切军事行动的指导原则，都根据于一个基本的原则，就是：尽可能地保存自己的力量，消灭敌人的力量。这个原则，在革命战争中是直接地和基本的政治原则联系着的。例如中国抗日战争的基本政治原则即政治目的，是驱逐日本帝国主义，建立独立自由幸福的新中国。在军事上实行起来，就是以军事力量保卫祖国，驱逐日寇。为达到这个目的，在军队本身的行动上，就表现为：一方面，尽可能地保存自己的力量；另一方面，尽可能地消灭敌人的力量。何以解释战争中提倡勇敢牺牲呢？每一战争都须支付代价，有时是极大的代价，岂非和“保存自己”相矛盾？其实一点也不矛盾，正确点说，是相反相成的。因为这种牺牲，不但是为了消灭敌人的必要，也是为了保存自己的必要——部分的暂时的“不保存”（牺牲或支付），是为了全体的永久的保存所必需的。在这个基本的原则上，发生了指导整个军事行动的一系列的所谓原则，从射击原则（荫蔽身体，发扬火力，前者为了保存自己，后者为了消灭敌人）起，到战略原则止，都贯彻这个基本原则的精神。一切技术的、战术的、战役的、战略的原则，都是执行这个基本原则时的条件。保存自己消灭敌人的原则，是一切军事原则的根据。   
## 第三章　抗日游击战争的六个具体战略问题  

  
　　现在我们来看，抗日游击战争的军事行动，应该采取些什么方针或原则才能达到保存自己消灭敌人的目的呢？因为抗日战争中（乃至一切革命战争中）的游击队一般是从无到有、从小到大的，故在保存自己之外，还须加上一个发展自己。所以问题是：应该采取些什么方针或原则才能达到保存或发展自己和消灭敌人的目的呢？   
　　总的说来，主要的方针有下列各项：（一）主动地、灵活地、有计划地执行防御战中的进攻战，持久战中的速决战和内线作战中的外线作战；（二）和正规战争相配合；（三）建立根据地；（四）战略防御和战略进攻；（五）向运动战发展；（六）正确的指挥关系。这六项，是全部抗日游击战争的战略纲领，是达到保存和发展自己，消灭和驱逐敌人，配合正规战争，争取最后胜利的必要途径。   
## 第四章　主动地灵活地有计划地执行防御战中的进攻战、持久战中的速决战、内线作战中的外线作战  

  
　　这里又可以分为四点来说：（一）防御和进攻，持久和速决，内线和外线的关系；（二）一切行动立于主动地位；（三）灵活地使用兵力；（四）一切行动的计划性。   
　　先说第一点。   
　　整个的抗日战争，由于日寇是强国，是进攻的，我们是弱国，是防御的，因而决定了我们是战略上的防御战和持久战。拿作战线来说，敌人是外线作战，我们是内线作战。这是一方面的情形。但是在又一方面，则适得其反。敌军虽强（武器和人员的某些素质，某些条件），但是数量不多，我军虽弱（同样，仅是武器和人员的某些素质，某些条件），但是数量甚多，加上敌人是异民族侵入我国，我们是在本国反抗异民族侵入这个条件，这样就决定了下列的战略方针：能够而且必须在战略的防御战之中采取战役和战斗的进攻战，在战略的持久战之中采取战役和战斗的速决战，在战略的内线作战之中采取战役和战斗的外线作战。这是整个抗日战争应该采取的战略方针。正规战争是如此，游击战争也是如此。游击战争所不同的，只是程度上或表现形式上的问题。游击战争是一般地用袭击的形式表现其进攻的。正规战争虽然也应该而且能够采用袭击战，但是其出敌不意的程度比较小一些。在游击战，速决性的要求是很大的，战役和战斗中包围敌人的外线圈则很小。这些都是和正规战不同的地方。   
　　由此可知，游击队的作战，要求集中可能多的兵力，采取秘密和神速的行动，出其不意地袭击敌人，很快地解决战斗；而要力戒消极防御，力戒拖延，并力戒临战分散兵力。当然，游击战争中不但战略上有防御，战术上也是有防御的；战斗时的钳制和警戒方面，隘路、险地、河川或村落等处为着消耗敌人和疲惫敌人的抵抗配置，退却时的掩护部队等等，都是游击战争中战术上的防御部分。然而游击战争的基本方针必须是进攻的，和正规战争比较起来，其进攻性更加大些，而且这种进攻必须是奇袭，大摇大摆大吹大擂地暴露自己，是较之正规战更加不能许可的。游击战争虽然也有坚持数天的战斗场合，例如攻击某个孤立无援的小敌，但一般的作战较之正规战更加要求迅速地解决战斗，这是被敌强我弱的情况规定了的。游击战争本来是分散的，所以成其为普遍的游击战，且在许多任务，例如扰乱、钳制、破坏和做群众工作等，都以分散兵力为原则；然而就一个游击部队或游击兵团，当着执行消灭敌人的任务，尤其是为着打破敌人的进攻而努力时，就仍须集中其主要的兵力。“集中大力，打敌小部”，仍然是游击战争战场作战的原则之一。   
　　由此也就可知，从整个的抗日战争看来，只有将正规战和游击战的战役和战斗的进攻战集合了很多，即从进攻战中打了很多的胜仗，才能达到战略防御之目的，最后战胜日本帝国主义。只有战役和战斗的速决战集合了很多，即是使得很多战役和战斗的进攻战都能因迅速解决战斗之故而取得了胜利，才能达到战略持久的目的，一方面争取时间加强抗战力量，同时促进和等候国际形势的变动和敌人的内溃，以便举行战略反攻，驱逐日寇出中国。也只有每战集中优势兵力，不论在战略防御时期也好，在战略反攻时期也好，一律采取战役和战斗中的外线作战，包围敌人而消灭之，不能包围其全部，也包围其一部，不能消灭所包围之全部，也消灭所包围之一部，不能大量俘虏所包围之敌，也大量杀伤所包围之敌。集合很多这样的歼灭战，才能转变敌我形势，将敌之战略包围，即敌之外线作战方针根本击破，最后配合国际的力量和日本人民的革命斗争，共同围剿日本帝国主义而一举消灭之。这些结果，主要地依靠正规战取得，游击战只有次一等的成绩。但是集合许多小胜化为大胜，则是正规战游击战所共同的。游击战争在抗日过程中起着伟大的战略作用，就是说的这一点。   
　　现在来说游击战争的主动性、灵活性、计划性的问题。   
　　游击战争的主动性是什么呢？   
　　一切战争的敌我双方，都力争在战场、战地、战区以至整个战争中的主动权，这种主动权即是军队的自由权。军队失掉了主动权，被逼处于被动地位，这个军队就不自由，就有被消灭或被打败的危险。本来战略的防御战和内线作战，争取主动较为困难些，而进攻的外线作战，争取主动较为容易些。但是日本帝国主义有两个基本的弱点，即是兵力不足和异国作战。并且因其对中国力量的估计不足和日本军阀的内部矛盾，产生了许多指挥的错误，例如逐渐增加兵力，缺乏战略的协同，某种时期没有主攻方向，某些作战失去时机和有包围无歼灭等等，可以说是他的第三个弱点。这样，兵力不足（包括小国、寡民、资源不足和他是封建的帝国主义等等），异国作战（包括战争的帝国主义性和野蛮性等等），指挥笨拙，使得日本军阀虽然处在进攻战和外线作战的有利地位，但其主动权却日益减弱下去。日本目前还不愿也不能结束战争，它的战略进攻也还没有停止，但是大势所趋，它的进攻是有一定限度的，这是三个弱点所产生的必然结果，无限止地吞灭全中国是不可能的。会有一天日本要处于完全的被动地位，这种情况现在就可以开始看出来。中国方面，开始时战争颇处于被动，现在因有了经验，正在改取新的运动战的方针，即战役和战斗的进攻战、速决战和外线作战的方针，加上普遍发展游击战的方针，所以主动地位正在日益建立起来。   
　　游击战争的主动权问题，是更加严重的问题。因为游击队大多处于严重的环境，这就是无后方作战的状态，敌强我弱的状态，缺乏经验的状态（这是说那些新成立的游击队）和不统一的状态等等。但是游击战争是能够建立其主动权的，主要的条件就是抓住上述敌人的三个弱点。欺他兵力不足（从整个战争看来），游击队就可以放手争取广大的活动地区；欺他是异民族，且执行极端的野蛮政策，游击队就可以放手争取千百万人民的拥护；欺他指挥笨拙，游击队就可以放手发挥自己的聪明。一切敌人的这些弱点，正规军也应捉住，作为自己战胜敌人的资本，但游击队尤其应当注意捉住。游击队自己的弱点，可以在斗争中逐渐减少。且其弱点有时正成为争取主动地位的条件，例如正是因为自己弱小，才利于在敌人后方神出鬼没地活动，敌人无奈他何，这样大的自由是庞大的正规军所不能得到的。   
　　游击队的主动权，在敌人举行数路围攻的场合，是难于掌握和容易丧失的。在这种场合，如果估计和处置得不正确，就容易处于被动，因而打不破敌人的围攻。在敌取守势我取攻势时，也有这种情形。所以主动权是从正确的情况估计（敌我双方的情况）和正确的军事政治处置产生的。不合客观情况的悲观的估计和随之而来的消极的处置，无疑地将丧失主动权，把自己抛入被动地位。但是同样，不合客观情况的过于乐观的估计和随之而来的冒险（不需要的那种冒险）的处置，也将丧失主动权，而最后归入悲观者一路。主动权不是任何天才家所固有的，只是聪明的领导者从虚心研究和正确地估计客观情况，正确地处置军事政治行动所产生的东西。因此，是要有意识地去争取的东西，不是现成的东西。   
　　已经因为估计和处置错误，或者因为不可抗的压力，被迫处于被动地位了的时候，这时的任务就是努力脱出这种被动。如何脱出法，须依情况而定。在许多情况下，“走”是必须的。游击队的会走，正是其特点。走是脱离被动恢复主动的主要的方法。但是不限于这一方法。往往在敌人十分起劲自己十分困难的时候，正是敌人开始不利，自己开始有利的时候。往往有这种情形，有利的情况和主动的恢复，产生于“再坚持一下”的努力之中。   
　　现在来说灵活性。   
　　灵活性就是具体地表现主动性的东西。灵活地使用兵力，是游击战争比较正规战争更加需要的。   
　　必须使游击战争的指导者明白，灵活地使用兵力，是转变敌我形势争取主动地位的最重要的手段。根据游击战争的特性，兵力的使用必须按照任务和敌情、地形、居民等条件作灵活的变动，主要的方法是分散使用、集中使用和转移兵力。游击战争的领导者对于使用游击队，好像渔人打网一样，要散得开，又要收得拢。当渔人把网散开时，要看清水的深浅、流的速度和那里有无障碍，游击队分散使用时，也须注意不要因情况不明、行动错误而受损失。渔人为了收得拢，就要握住网的绳头，使用部队也要保持通讯联络，并保持相当主力在自己手中。打鱼要时常变换地点，游击队也要时常变换位置。分散、集中和变换，是游击战争灵活使用兵力的三个方法。   
　　一般地说来，游击队当分散使用，即所谓“化整为零”时，大体上是依下述几种情况实施的：（一）因敌取守势，暂时无集中打仗可能，采取对敌实行宽大正面的威胁时；（二）在敌兵力薄弱地区，进行普遍的骚扰和破坏时；（三）无法打破敌之围攻，为着减小目标以求脱离敌人时；（四）地形或给养受限制时；（五）在广大地区内进行民众运动时。但不论何种情况，当分散行动时都须注意：（一）保持较大一部分兵力于适当的机动地区，不要绝对地平均分散，一则便于应付可能的事变，一则使分散执行的任务有一个重心；（二）给各分散部队以明确的任务、行动的地区、行动的时期、集合的地点、联络的方法等。   
　　集中使用兵力，即所谓“化零为整”的办法，多半是在敌人进攻之时为了消灭敌人而采取的；也有在敌人取守势时，为了消灭某些驻止之敌而采取的。集中兵力并不是说绝对的集中，集中主力使用于某一重要方面，对其他方面则留置或派出部分兵力，为钳制、扰乱、破坏等用，或作民众运动。   
　　按照情况灵活地分散兵力或集中兵力，是游击战争的主要的方法，但是还须懂得灵活地转移（变换）兵力。当敌人感到游击队对他有了大的危害时，就会派兵镇压或举行进攻。因此，游击队要考虑情况，如果可以打时，就在当地打仗；如果不能打时，就应不失时机，迅速地转移到另一方向去。有时为着各个击破敌人，有刚才在这里消灭了敌人，又立即转移到另一方向去消灭敌人的；也有在这里不利于战斗，要立即脱离此敌转移到另一方向去进行战斗的。如果敌情特别严重，游击部队不应久留一地，要像流水和疾风一样，迅速地移动其位置。兵力转移，一般都要秘密迅速。经常要采取巧妙的方法，去欺骗、引诱和迷惑敌人，例如声东击西、忽南忽北、即打即离、夜间行动等。   
　　分散、集中和转移的灵活性，都是游击战争具体地表现主动性的东西；死板、呆滞，必至陷入被动地位，遭受不必要的损失。但领导者的聪明不在懂得灵活使用兵力的重要，而在按照具体情况善于及时地实行分散、集中和转移兵力。这种善观风色和善择时机的聪明是不容易的，惟有虚心研究，勤于考察和思索的人们可以获得。为使灵活不变为妄动，慎重地考虑情况是必要的。   
　　最后说到计划性问题。   
　　游击战争要取得胜利，是不能离开它的计划性的。乱干一场的想法，只是玩弄游击战争，或者是游击战争的外行。不论是整个游击区的行动或是单个游击部队或游击兵团的行动，事先都应有尽可能的严密的计划，这就是一切行动的预先准备工作。情况的了解，任务的确定，兵力的部署，军事和政治教育的实施，给养的筹划，装备的整理，民众条件的配合等等，都要包括在领导者们的过细考虑、切实执行和检查执行程度的工作之中。没有这个条件，什么主动、灵活、进攻等事，都是不能实现的。固然正规战争的计划性更大些，游击战争的条件不容许很大的计划性，如果企图在游击战争中实行高度的严密的计划工作，那是错误的；但依照客观条件允许的程度，采取尽可能的严密的计划，则是必要的，须知同敌人斗争是一件不能开玩笑的事情。   
　　上面所说的各点，说明了游击战争战略原则的第一个问题——主动地、灵活地、有计划地执行防御中的进攻战，持久中的速决战，内线作战中的外线作战。这是游击战争战略原则的最中心的问题。解决了这个问题，游击战争的胜利就有了军事指导上的重要的保证。   
　　这里虽说了许多的东西，但一切都环绕于战役和战斗的进攻。主动地位只有在进攻胜利之后，才能最后地取得。一切进攻战也都要主动地组织之，不要被迫地采取进攻。灵活地使用兵力，环绕于为着进攻战这个中心；计划性的必要，主要地也是为了进攻的胜利。战术上的防御手段，离开直接或间接协助进攻，则毫无意义。速决是说的进攻的时间，外线是说的进攻的范围。进攻是消灭敌人的唯一手段，也是保存自己的主要手段，单纯的防御和退却，对于保存自己只有暂时的部分的作用，对于消灭敌人则完全无用。   
　　这个原则，正规战争和游击战争是基本上同一的，只在表现形式上有程度的不同。但在游击战争中注意这个不同是重要的和必要的。正是因为这个不同的表现形式，所以使游击战争的作战方法区别于正规战争的作战方法；混淆了这个不同的表现形式，游击战争是不能胜利的。   
## 第五章　和正规战争相配合  

  
　　游击战争战略问题的第二个问题，是和正规战争相配合的问题。这是依据游击战争具体行动的性质，说明它在作战上和正规战争的关系。认识这种关系，对于有效地战胜敌人，是有重要意义的。   
　　游击战争和正规战争的配合有三种：战略的、战役的和战斗的。   
　　整个游击战争，在敌人后方所起的削弱敌人、钳制敌人、妨碍敌人运输的作用，和给予全国正规军和全国人民精神上的鼓励等等，都是战略上配合了正规战争。例如东三省的游击战争，在全国抗战未起以前当然不发生配合问题，但在抗战起来以后，配合的意义就明显地表现出来了。那里的游击队多打死一个敌兵，多消耗一个敌弹，多钳制一个敌兵使之不能入关南下，就算对整个抗战增加了一分力量。至其给予整个敌军敌国以精神上的不利影响，给予整个我军和人民以精神上的良好影响，也是显而易见的。至于平绥、平汉、津浦、同蒲、正太、沪杭诸铁路线两旁的游击战争，所起战略的配合作用，更加容易看到。它们不但在现时敌人举行战略进攻时配合正规军起了战略防御的作用；又不但在敌人结束其战略进攻转入保守占领地时，将配合正规军妨碍敌之保守；而且将于正规军举行战略反攻时，配合正规军击退敌军恢复整个的失地。游击战争在战略上的伟大的配合作用，是不容忽视的。游击队和正规军的领导者们，都应明确地认识其作用。   
　　不但如此，游击战争还有其战役的配合作用。例如，太原北部忻口战役时，雁门关南北的游击战争破坏同蒲铁路、平型关汽车路、阳方口汽车路，所起的战役配合作用，是很大的。又如敌占风陵渡后，普遍存在于山西各地的游击战争（主要是由正规军进行的），对于配合陕西、河南两省沿黄河西南两岸的防御战，所起的战役配合作用更是很大的。再如敌攻鲁南时，整个华北五省的游击战争，对于配合鲁南我军的战役作战，也尽了相当的力量。在这个任务上，一切处于敌后的游击根据地的领导者们，或临时被派出的游击兵团的领导者们，必须好好地配置自己的力量，各依当时当地的情况，采用不同的方法，向着敌人最感危害之点和薄弱之点积极地行动起来，达到削弱敌人、钳制敌人、妨碍敌人运输和精神上振奋内线上各个战役作战军之目的，尽其战役配合的责任。如果各游击区或各游击队只是各干各的，不顾战役作战的配合，虽在总的战略作战上仍不失其配合作用，但由于没有战役作战的配合，也就减少了它们的战略配合的意义。这一点是一切游击战争的领导者应该深切地注意的。为达此目的，无线电通讯之普遍地设置于一切较大的游击部队和游击兵团，实有完全的必要。   
　　最后，战斗的配合，即战场作战的配合，是一切内线战场附近的游击队的任务，这一项当然只限于靠近正规军的游击队，或临时从正规军派出的游击队。在这种场合，游击队应该依正规军首长的指示，担负其所指定的任务，往往是担负钳制部分的敌人，妨碍敌之运输，侦察敌情，充当向导等。没有正规军首长的指示时，游击队也应自动地做这些事。坐视不理，不游不击，或游而不击的态度，是要不得的。   
## 第六章　建立根据地  

  
　　抗日游击战争战略问题的第三个问题，是建立根据地的问题。这个问题的必要性和重要性，是随着战争的长期性和残酷性而来的。因为失地的恢复须待举行全国的战略反攻之时，在这以前，敌人的前线将深入和纵断我国的中部，小半甚至大半的国土被控制于敌手，成了敌人的后方。我们要在这样广大的被敌占领地区发动普遍的游击战争，将敌人的后方也变成他们的前线，使敌人在其整个占领地上不能停止战争。我们的战略反攻一日未能举行，失地一日未能恢复，敌后游击战争就应坚持一日，这种时间虽不能确切断定，然而无疑地是相当地长，这就是战争的长期性。同时敌人为了确保占领地的利益，必将日益加紧地对付游击战争，特别在其战略进攻停止之后，必将残酷地镇压游击队。这样，长期性加上残酷性，处于敌后的游击战争，没有根据地是不能支持的。   
　　游击战争的根据地是什么呢？它是游击战争赖以执行自己的战略任务，达到保存和发展自己、消灭和驱逐敌人之目的的战略基地。没有这种战略基地，一切战略任务的执行和战争目的的实现就失掉了依托。无后方作战，本来是敌后游击战争的特点，因为它是同国家的总后方脱离的。然而，没有根据地，游击战争是不能够长期地生存和发展的，这种根据地也就是游击战争的后方。   
　　历史上存在过许多流寇主义的农民战争，都没有成功。在交通和技术进步的今日而企图用流寇主义获得胜利，更是毫无根据的幻想。然而流寇主义在今天的破产农民中还是存在的，他们的意识反映到游击战争的领导者们的头脑中，就成了不要或不重视根据地的思想。因此，从游击战争的领导者们的头脑中驱除流寇主义，是确定建立根据地的方针的前提。要或不要根据地、重视或不重视根据地的问题，换句话说，根据地思想和流寇主义思想的斗争的问题，是任何游击战争中都会发生的，抗日游击战争在某种程度上也不能是例外。因此，同流寇主义作思想斗争，将是一个不可少的过程。只有彻底地克服了流寇主义，提出并实行建立根据地的方针，才能有利于长期支持的游击战争。   
　　在说明了根据地的必要和重要性之后，下面的问题是实行建立根据地时必须认识和解决的。这些问题是：几种根据地，游击区和根据地，建立根据地的条件，根据地的巩固和发展，敌我之间的几种包围。   
### 第一节　几种根据地  

  
　　抗日游击战争的根据地大体不外三种：山地、平地和河湖港汊地。   
　　山地建立根据地之有利是人人明白的，已经建立或正在建立或准备建立的长白山⑴、五台山⑵、太行山⑶、泰山⑷、燕山⑸、茅山⑹等根据地都是。这些根据地将是抗日游击战争最能长期支持的场所，是抗日战争的重要堡垒。我们必须到一切处于敌后的山岳地带去发展游击战争，并建立起根据地来。   
　　平地较之山地当然差些，然而决不是不能发展游击战争，也不是不能建立任何的根据地。河北平原、山东的北部和西北部平原，已经发展了广大的游击战争，是平地能够发展游击战争的证据。至于能否在平原地区建立长期支持的根据地，这一点现在还没有证明；但是建立临时的根据地和小部队的或季候性的根据地，则前者现在已经证明，后者也应该说是可能的。因为一方面，敌人兵力不够分配，又执行着前无古人的野蛮政策，另一方面，中国有广大的土地，又有众多的抗日人民，这些都提供了平原能够发展游击战争并建立临时根据地的客观条件；如再加上指挥适当一条，则小部队的非固定的长期根据地之建立，当然应该说是可能的⑺。大抵当敌人结束了他的战略进攻，转到了保守占领地的阶段时，对于一切游击战争根据地的残酷进攻的到来，是没有疑义的，平原的游击根据地自将首当其冲。那时，在平原地带活动的大的游击兵团将不能在原地长期支持作战，而须按照情况，逐渐地转移到山地里去，例如从河北平原向五台山和太行山转移，从山东平原向泰山和胶东半岛转移。但是保持许多小的游击部队，分处于广大平原的各县，采取流动作战，即根据地搬家，一时在此一时在彼的方法，在民族战争的条件下，不能说没有这种可能。至于利用夏季的青纱帐和冬季的河川结冰之季候性的游击战争，那是断然可能的。在现时敌人无力顾及和将来顾及也难周到的条件下，确定在现时广泛地发展平原的游击战争，并建立临时根据地的方针，在将来准备坚持小部队的游击战争，至少坚持季候性的游击战争，并建立非固定的根据地的方针，是完全必要的。   
　　依据河湖港汊发展游击战争，并建立根据地的可能性，客观上说来是较之平原地带为大，仅次于山岳地带一等。历史上所谓“海盗”和“水寇”，曾演过无数的武剧，红军时代的洪湖游击战争支持了数年之久，都是河湖港汊地带能够发展游击战争并建立根据地的证据。不过，各个抗日党派和抗日人民，至今尚少注意这一方面。虽然主观条件还不具备，然而无疑地是应该注意和应该进行的。江北的洪泽湖地带、江南的太湖地带和沿江沿海一切敌人占领区域的港汊地带，都应该好好地组织游击战争，并在河湖港汊之中及其近旁建立起持久的根据地，作为发展全国游击战争的一个方面。缺少了这一方面，无异供给敌人以水上交通的便利，是抗日战争战略计划的一个缺陷，应该及时地补足之。   
### 第二节　游击区和根据地  

  
　　在处于敌人后方作战的游击战争面前，游击区和根据地是有区别的。在四围已被敌占但中间未被敌占或虽占而已经恢复的地区，例如五台山地区（即晋察冀边区）的某些县，太行山地区和泰山地区也有这种情形，这些都是现成的根据地，游击队据之以发展游击战争是很方便的。但在这些根据地的其他地方则不然，例如五台山地区的东部北部——即冀西察南的某些部分和保定以东沧州以西的许多地方，在那里，游击战争在开始时期还不能完全占领该地，只能经常去游击，游击队到时属于游击队，游击队走了又属于伪政权，这样的地区就还不是游击战争的根据地，而是所谓游击区。这种游击区，经过游击战争的必要过程，消灭或打败了许多敌人，摧毁了伪政权，发动了民众的积极性，组织了民众的抗日团体，发展了民众武装，建立了抗日政权，游击区就转化成了根据地。将这些根据地，增加到原有的根据地里面去，就叫做发展了根据地。   
　　有些地方的游击战争，全部活动地区开始都是游击区，例如冀东的游击战争。那里已有长期的伪政权，当地起义的民众武装和从五台山派去的游击支队，整个活动地区开始都是游击区。它们在开始活动时，只能在此区中选择好的地点作为临时的后方，或叫做临时根据地。要待消灭敌人和发动民众的工作开展了之后，才能把游击区状态消灭，变为比较稳固的根据地。   
　　由此可知，从游击区到根据地，是一个艰难缔造的过程，依消灭敌人和发动民众的程度如何而定其是否已从游击区过渡到了根据地的阶段。   
　　有许多地区，将是长期地处于游击区状态的。在那里，敌人极力控制，但不能建立稳固的伪政权，游击战争也极力发展，但无法达到建立抗日政权的目的，例如敌人占领的铁路线、大城市的附近地区和某些平原地区。   
　　至于敌人有强大力量控制着的大城市、火车站和某些平原地带，游击战争只能接近其附近，而不能侵入其里面，那里有比较稳固的伪政权，这又是一种情形。   
　　由于我之领导错误或敌之强大压力的结果，可以使上述的情形发生相反的变化，即根据地化为游击区，游击区化为敌之比较稳固的占领地。这种情形是可能发生的，值得游击战争的领导者们特别警戒。   
　　所以，在整个敌占地区，经过游击战争和敌我双方斗争的结果，可以变为三种情况的地方：第一种是被我方游击部队和我方政权掌握着的抗日根据地；第二种是被日本帝国主义和伪政权掌握着的被占领地；第三种是双方争夺的中间地带，即所谓游击区。游击战争领导者的责任，在于极力扩大第一、第三两种地区，而极力缩小第二种地区。这就是游击战争的战略任务。   
### 第三节　建立根据地的条件  

  
　　建立根据地的基本条件，是要有一个抗日的武装部队，并使用这个部队去战胜敌人，发动民众。所以建立根据地问题，首先就是武装部队问题。从事游击战争的领导者们必须用全副精力去建立一支以至多支的游击部队，并使之从斗争中逐渐地发展为游击兵团，以至发展成为正规部队和正规兵团。建立武装部队是建立根据地的最基本一环，没有这个东西，或有了而无力量，一切问题都无从说起。这是第一个条件。   
　　和建立根据地不能分离的第二个条件，就是使用武装部队并配合民众去战胜敌人。凡是被敌人控制的地方，那是敌人的根据地，不是游击战争的根据地；要把敌人的根据地变为游击战争的根据地，非战胜敌人无从实现，这是自明之理。就是游击战争控制的地方，如果不粉碎敌人的进攻，不战胜敌人，自己控制的地方就要变成敌人控制的地方，也无从建立根据地。   
　　和建立根据地不可分离的第三个条件，就是用一切力量，包括武装部队的力量在内，去发动民众的抗日斗争。要从这种斗争中去武装人民，即组织自卫军和游击队。要从这种斗争中去组织民众团体；无论是工人、农民、青年、妇女、儿童、商人、自由职业者，都要依据他们的政治觉悟和斗争情绪提高的程度，将其组织在各种必要的抗日团体之内，并逐渐地发展这些团体。民众如没有组织，是不能表现其抗日力量的。要从这种斗争中去肃清公开的或隐藏的汉奸势力；要做到这一步也只有依靠民众的力量。尤其重要的是从这种斗争中去发动民众建立或巩固当地的抗日政权。原来有中国政权未被敌人破坏的，则在广大民众拥护的基础之上去改造它和巩固它；原来的中国政权已被敌人破坏了的，则在广大民众努力的基础之上去恢复它。这个政权是实行抗日民族统一战线政策的，它应该团结一切人民的力量，向唯一的敌人日本帝国主义及其走狗汉奸反动派作斗争。   
　　一切游击战争的根据地，只有在建立了抗日的武装部队、战胜了敌人、发动了民众这三个基本的条件逐渐地具备之后，才能真正地建立起来。   
　　此外，还须指出的是地理和经济的条件。地理条件的问题，在说“几种根据地”时已经指出了三种不同的情形，这里只说主要的要求，即地区的广大。处在四面或三面被敌包围的中间，要建立长期支持的根据地，山地当然是最好的条件，但主要是须有游击队回旋的余地，即广大地区。有了广大地区这个条件，就是在平原也是能够发展和支持游击战争的，河湖港汊更不待说。这个条件已因中国领土广大和敌人兵力不足，一般地提供于中国的游击战争了。从游击战争的可能性说来，它是一个重要的甚至是第一个重要的条件；在小国如比利时等，因没有这个条件，游击战争的可能性就很小，甚至没有。但在中国，这个条件已不是什么待争取的条件和待解决的问题，而是自然具备只待人去利用的东西。   
　　经济条件的性质，从其自然性一方面看来，也和地理条件相同。因为现在并不讨论在沙漠里建立根据地，沙漠里也没有什么敌人，讨论的是在敌人后方建立根据地，而一切敌人能到之处，当然早就有了中国人，也早就有了吃饭的经济基础，故在建立根据地问题上，不发生选择经济条件的问题。一切有中国人又有敌人的地方，不问其经济条件如何，都应尽可能地发展游击战争，并建立永久的或临时的根据地。但从其政治性一方面看来则不然，这里的问题是存在的，这就是经济政策的问题，这一点对于建立根据地是带着严重性的。游击战争根据地的经济政策，必须执行抗日民族统一战线的原则，即合理负担和保护商业，当地政权和游击队决不能破坏这种原则，否则将影响于根据地的建立和游击战争的支持。合理负担即实行“有钱者出钱”，但农民亦须供给一定限度的粮食与游击队。保护商业应表现于游击队的严格的纪律上面；除了有真凭实据的汉奸之外，决不准乱没收一家商店。这是困难的事，但这是必须执行的确定的政策。   
### 第四节　根据地的巩固和发展  

  
　　为了把侵入中国的敌人围困在少数的据点，即大城市和交通干线之内，各个根据地上的游击战争必须极力向其根据地的四周发展，迫近一切敌人的据点，威胁其生存，动摇其军心，同时即发展了游击战争的根据地，这是十分必要的。这里，要反对游击战争中的保守主义。保守主义不论是由于贪图安逸而发生的，或由于对敌人力量的过高估计而发生的，均将给予抗日战争以损失，对于游击战争及其根据地的本身也是不利的。另一方面，不可忘记根据地的巩固，而其主要的工作是发动和组织民众，以及游击部队和地方武装的训练。这种巩固，是支持长期战争所必需，也是向前发展所必需的，不巩固就不能有力地向前发展。只知道发展忘记了巩固的游击战争，经不起敌人的进攻，结果不但丧失了发展，且有危及根据地本身之虞。正确的方针是巩固地向前发展，这是进可以攻退可以守的好办法。只要是长期战争，根据地的巩固和发展的问题，是每个游击队经常发生的问题。具体解决时应依照情况去决定。某一时期，把重心放在发展方面，这就是推广游击区、扩大游击队的工作。另一时期，则把重心放在巩固方面，这就是组织民众、训练部队的工作。因为二者的性质不同，军事部署和工作执行随之而不同，必须依情况分时期有所侧重，才能很好地解决这个问题。   
### 第五节　敌我之间的几种包围  

  
　　从整个抗日战争看来，由于敌之战略进攻和外线作战，我处战略防御和内线作战地位，无疑我是处在敌之战略包围中。这是敌对于我的第一种包围。由于我以数量上优势的兵力，对于从外线分数路向我前进之敌采取战役和战斗的进攻和外线作战的方针，就使各个分进之敌的每一个处于我之包围中。这是我对于敌的第一种包围。再从敌后游击战争的根据地看来，每一孤立的根据地都处于敌之四面或三面包围中，前者例如五台山地区，后者例如晋西北地区。这是敌对于我的第二种包围。但若将各个根据地联系起来看，并将各个游击战争根据地和正规军的战线联系起来看，我又把许多敌人都包围起来。例如在山西，我已三面包围了同蒲路（路之东西两侧及南端），四面包围了太原城；在河北、山东等省，亦有许多这样的包围。这是我对于敌的第二种包围。由是敌我各有加于对方的两种包围，大体上好似下围棋⑻一样，敌对于我我对于敌之战役和战斗的作战好似吃子，敌之据点和我之游击根据地则好似做眼。在这个“做眼”的问题上，表示了敌后游击战争根据地之战略作用的重大性。这个问题，提在抗日战争面前，就是一方面在全国军事当局，又一方面在各地的游击战争领导者，均须把在敌后发展游击战争和在一切可能地方建立根据地的任务，放在自己的议事日程上，把它作为战略任务执行起来。如果我们能在外交上建立太平洋反日阵线，把中国作为一个战略单位，又把苏联及其他可能的国家也各作为一个战略单位，我们就比敌人多了一个包围，形成了一个太平洋的外线作战，可以围剿法西斯日本。这一点在今天当然还没有实际意义，但不是没有这种前途的。   
## 第七章　游击战争的战略防御和战略进攻  

  
　　游击战争战略问题的第四个问题，是游击战争的战略防御和战略进攻的问题。这是第一个问题里所述的进攻战方针在抗日游击战争处于防御姿势和处于进攻姿势中如何具体地应用的问题。   
　　在全国的战略防御和战略进攻（正确地说，战略反攻）中间，每一游击战争的根据地上面及其周围，也有其小规模的战略防御和战略进攻，前者是敌取攻势我取守势时的战略形势和战略方针，后者是敌取守势我取攻势时的战略形势和战略方针。   
### 第一节　游击战争的战略防御  

  
　　在游击战争已经起来并有相当的发展之后，特别是在敌人停止了对我全国的战略进攻、采取保守其占领地的方针的时候，敌人向游击战争根据地的进攻是必然的。对于这种必然性的认识是必要的，否则游击战争的领导者们全无准备，一旦遇到敌人严重地进攻的形势，必至惊惶失措，被敌击破。   
　　敌人为达到消灭游击战争及其根据地之目的，常会采取围攻的办法，例如五台山地区就已有了四五次的所谓“讨伐”，每次配置三路、四路以至六、七路的兵力，同时有计划地前进。游击战争发展的规模越大，其根据地所处的位置越重要，威胁敌人的战略基地和交通要道越大，敌人对于游击战争及其根据地的进攻也将会越厉害。所以，凡属敌人进攻游击战争越厉害之处，就证明那里的游击战争越有成绩，对于正规战争的配合也就越有作用。   
　　在敌人数路围攻的情况之下，游击战争的方针是打破这种围攻，采取反围攻的形态。在敌数路前进，但每路只有一个或大或小的部队，没有后续部队，不能沿途配置兵力、构筑堡垒、修筑汽车路的情况之下，这种围攻是容易打破的。这时，敌是进攻和外线作战，我是防御和内线作战。我之部署应是以次要兵力钳制敌之数路，而以主要兵力对付敌之一路，采取战役和战斗的袭击战法（主要的是埋伏战），于敌行动中打击之。敌人虽强，经过多次的袭击，也就削弱下来，往往中途撤退，此时游击队又可于追击敌人时继续袭击，再行削弱他。当敌人还没有停止进攻或实行退却之时，总是占据根据地内的县城或市镇，我便应包围这种县城或市镇，断绝其粮食来源和交通联络，等到敌人无法支持向后退走时，我便乘机追击之。一路打破之后，又转移兵力去打破敌之另一路，这样各个地击破敌之围攻。   
　　在一个大的根据地内，例如五台山地区，是在一个“军区”之内分为四五个或更多的“军分区”的，每一军分区都有独立作战的武装部队。在上述作战方法之下，往往同时地或先后地打破了敌人的进攻。   
　　在反围攻的作战计划中，我之主力一般是位于内线的。但在兵力优裕的条件下，使用次要力量（例如县和区的游击队，以至从主力中分出一部分）于外线，在那里破坏敌之交通，钳制敌之增援部队，是必要的。如果敌在根据地内久踞不去，我可以倒置地使用上述方法，即以一部留在根据地内围困该敌，而用主力进攻敌所从来之一带地方，在那里大肆活动，引致久踞之敌撤退出去打我主力；这就是“围魏救赵”⑼的办法。   
　　在反围攻的作战中，地方人民的抗日自卫军和一切民众组织，应全体动员起来参加战争，用各种方法帮助我军，反对敌人。在反对敌人的工作中，地方戒严和可能程度的坚壁清野两事是重要的。前者为了镇压汉奸，并使敌人得不到消息；后者为了协助作战（坚壁），并使敌人得不到粮食（清野）。这里所说的清野，是指粮食成熟时早日收割的意思。   
　　敌人退却时往往将所踞城市中的房屋和所经道路上的村庄放火烧毁，目的在给予游击战争根据地以破坏，但同时就使得敌人第二次进攻时没有房子住和没有饭吃，害了他们自己。这就是所谓在一件事情上面包含着两种互相矛盾的意义的具体例证之一。   
　　不是在几经反围攻之后业已证明在那里无法打破严重的围攻时，游击战争的领导者不应企图放弃那个根据地而跑到别的根据地去。在这里，应注意防止悲观情绪的发生。只要领导上不犯原则错误，一般的山岳地带，总是能够打破围攻和坚持根据地的。只有平原地带，如果在严重的围攻之下，就应根据具体情势，考虑下面的问题：留着许多小的游击部队在当地分散活动，而将大的游击兵团暂时地转移到山地里去，等到敌人主力移动他去，我又再往那里活动。   
　　由于中国地区广大、敌人兵力不足的矛盾情况，敌人是一般地不能采取中国内战时国民党的堡垒主义的。但是我们应该估计到在某些特别威胁敌人要害的游击根据地中，敌人有可能采取相当程度的堡垒主义，要准备就是在这种情况之下仍然坚持那里的游击战争。毫无疑义的，根据在内战时还能坚持游击战争的经验，在民族战争中当然更能够坚持。因为即使在兵力对比上，在某些根据地中，敌能使用不但在质量上而且在数量上极端优势的兵力，但是敌我民族矛盾无法解决，敌之指挥弱点无可避免。我之胜利，就建立在深入的民众工作和灵活的作战方法之上。   
### 第二节　游击战争的战略进攻  

  
　　在已将敌之进攻打破，敌之新的进攻尚未到来的时候，是敌取战略守势我取战略攻势的时候。   
　　这种时候，我之作战方针，不在于攻击不可必胜的、固守着防御阵地的敌人；而在于有计划地在一定地区内消灭和驱逐为游击队力能胜任的小敌和汉奸武装，扩大我之占领地区，发动民众的抗日斗争，补充并训练部队，组织新的游击队。在这些任务做得有了些眉目之后，如果敌人还在守势之中，就可以进一步扩大我之新占领地区，攻击那些敌力薄弱的城市和交通线，依其情况而长久地或暂时地占领之。所有这些，都是战略进攻的任务，目的在于乘着敌取守势之时，有效地发展自己的军事的和民众的力量，有效地缩小敌人的力量，并准备敌人再度向我进攻时又能有计划地和有力地打破之。   
　　部队的休息和训练是必要的，敌取守势时是我最好的休息和训练的时机。不是一事不做专门关起门来休息和训练，而是在扩大占领地，消灭小敌，发动民众的工作中，争取时间达到休息和训练的目的。解决给养被服等困难问题，也往往在这个时候。   
　　大规模地破坏敌之交通线，妨碍敌之运输，直接帮助正规军的战役作战，也在这个时候。   
　　这时，整个的游击根据地、游击区和游击部队，都是兴高采烈的时候，被敌摧残的地区也逐渐整理，恢复元气。敌占地区内的民众亦十分高兴，到处都传播游击队的声威。敌人及其走狗汉奸的内部，则一方面发展着恐慌情绪和分化作用，一方面又增加着对于游击队和根据地的仇恨，加紧地准备着对付游击战争。因此，游击战争的领导者们不可在自己的战略进攻中得意忘形，轻视敌人，忘记了团结内部、巩固根据地和巩固部队的工作。在这种时候，须善于观看敌人的风色，看其是否又有向我进攻的朕兆，以便一遇进攻，就能适当地结束我之战略进攻，转入战略防御，再从战略防御中粉碎敌人的进攻。   
## 第八章　向运动战发展  

  
　　抗日游击战争战略问题的第五个问题，是向运动战发展的问题，其必要和可能，也是由于战争的长期性和残酷性而来的。如果中国能迅速地战胜日寇，并迅速地收复失地，没有什么持久战，也不是什么残酷的战争，那末，游击战向运动战发展的必要就不存在。然而情形是相反的，战争是长期而且残酷，游击战只有向运动战发展才能适应这样的战争。战争既是长期的和残酷的，就能够使游击队受到必要的锻炼，逐渐地变成正规的部队，因而其作战方式也将逐渐地正规化，游击战就变成运动战了。游击战争的领导者们必须明确地认识这种必要性和可能性，才能坚持向运动战发展的方针，并有计划地执行之。   
　　现在许多地方的游击战争，例如五台山等处，是由正规军派出强大的支队去发展的。那里的作战虽然一般是游击战，但开始即包含了运动战的成分。随着战争的持久，这种成分将逐渐地增加。这是今天抗日游击战争的长处，不但使游击战争迅速地发展，并且使之迅速地提高，较之东三省的游击战争，条件优越得多了。   
　　由执行游击战的游击部队化为执行运动战的正规部队，须具备数量扩大和质量提高两个条件。前者除直接动员人民加入部队外，可采取集中小部队的办法；后者则依靠战争中的锻炼和提高武器的质量。   
　　集中小部队，一方面，须防止只顾地方利益因而妨碍集中的地方主义；另一方面，也须防止不顾地方利益的单纯军事主义。   
　　地方主义是存在于地方游击队和地方政府中间的，他们往往只顾地方的利益，忘记全局的利益，或贪图分散活动，不惯集团生活。主力游击部队或游击兵团的领导者们，必须注意到这种情形，采取逐渐地和部分地集中的办法，使地方保有余力能够继续地发展游击战争；采取首先协同行动然后实行合编以及不破坏其建制不撤换其干部的办法，使小集团能够融合于大集团。   
　　单纯军事主义和地方主义相反，乃是主力部队里头的人们只图扩充自己不顾扶助地方武装的一种错误观点。他们不知道游击战向运动战发展并非废除游击战，而是在广泛发展的游击战之中逐渐地形成一个能够执行运动战的主力，环绕这个主力的仍然应有广大的游击部队和游击战争。这种广大的游击部队，造成这个主力的丰富的羽翼，又是这个主力继续扩大的不断的源泉。所以，主力部队的领导者如果犯了不顾地方民众和地方政府的利益的单纯军事主义的错误，就必须加以克服，使主力的扩大和地方武装的繁殖，各得着适宜的位置。   
　　提高质量，须在政治、组织、装备、技术、战术、纪律等各方面有所改进，逐渐地仿照正规军的规模，减少游击队的作风。政治上须使指挥员、战斗员们认识从游击队到正规军提高一步的必要性，鼓励大家为此而努力，并以政治工作去保障之。组织上须逐渐地具备为一个正规兵团所必需的军事和政治的工作机关，军事和政治的工作人员，军事和政治的工作方法以及供给卫生等的经常制度。装备方面，须提高武器的质量和种类，增加必要的通讯器材。技术和战术方面，从游击部队的技术和战术提高到作为一个正规兵团所必需的技术和战术。纪律方面，提高到整齐划一令行禁止的程度，消灭自由和散漫的现象。所有这些方面的完成，需要一个长的努力过程，不是一朝一夕的工程，然而必须向这个方向发展。只有这样，一个游击战争根据地上面的主力兵团才能造成，更有效力地打击敌人的运动战方式才能出现。这种目的，在有正规军派遣支队或派遣干部的地方，是能够比较顺利地达到的。因此，一切正规军均有扶助游击队向着正规部队发展的责任。   
## 第九章　指挥关系  

  
　　抗日游击战争战略问题的最后一个问题，是指挥关系的问题。这个问题的正确解决，是游击战争顺利发展的条件之一。   
　　游击战争的指挥方法，由于游击部队是低级的武装组织和分散行动的特性，不容许高度的集中主义，如同正规战争的指挥方法那样。如果企图拿正规战争的指挥方法施之于游击战争，必然地要束缚游击战争的高度活泼性，而使游击战争毫无生气。高度的集中指挥和游击战争的高度活泼性是正相反对的东西；对于这种高度活泼的游击战争，施之以高度集中的指挥制度，不但不应该，而且不可能。   
　　然而游击战争不是不要任何的集中指挥就能够顺利地发展的。在有广大的正规战争，同时又有广大的游击战争存在的情况之下，使二者适当地配合行动是必要的，这里就需要对于正规战争和游击战争配合行动的指挥，这就是国家参谋部和战区司令官关于战略作战的统一指挥。在一个游击区或游击根据地里面，那里存在着多数的游击队，其中往往有一个至数个作为主力的游击兵团（有时还有正规兵团）和许多作为辅助力量的大小游击部队，还有不脱离生产的广大的人民武装，那里的敌人也往往成为一个局面，统一地对付游击战争。因此，就在这种游击区或根据地里面，发生了统一指挥，即集中指挥的问题。   
　　由此，游击战争的指挥原则，一方面反对绝对的集中主义，同时又反对绝对的分散主义，应该是战略的集中指挥和战役战斗的分散指挥。   
　　战略的集中指挥，包括国家对于整个游击战争的部署，各个战区里面游击战争和正规战争的配合行动以及每个游击区或根据地里面对于全区抗日武装的统一指导。在这些上面的不协调、不统一、不集中，是有害的，应该尽可能地求得其协调、统一和集中。凡关于一般事项，即战略性质的事项，下级必须报告上级，并接受上级的指导，以收协同动作之效。然而集中到此为止，过此限度，干涉到下级的具体事项，例如战役战斗的具体部署等等，同样是有害的。因为这些具体事项，必须按照随时变化随地不同的具体情况去做，而这些具体情况，是离得很远的上级机关无从知道的。这就是战役和战斗的分散指挥原则。这个原则也一般地通用于正规战争的作战，特别是在通讯工具不完备的情况下。一句话，就是：战略统一下的独立自主的游击战争。   
　　在游击根据地组成一个军区，其下分为几个军分区，军分区之下分为几个县，县之下分为几个区的情况，军区司令部、军分区司令部、县政府、区政府的系统是隶属关系，武装部队依其性质分别地隶属之。它们之间的指挥关系，根据上述的原则，一般的方针集中于上级；具体的行动按照具体情况实施之，下级有独立自主之权。上级对下级某些具体行动有意见，可以而且应该作为“训令”提出，但决不应作为不可改变的“命令”。越是地区广大，情况复杂，上下级距离很远，这种具体行动就越应加大其独立自主的权限，越应使之多带地方性，多切合地方情况的要求，以便培养下级和地方人员的独立工作能力，应付复杂的环境，发展胜利的游击战争。如果是一个集中行动的部队或兵团，其内部指挥关系，适用集中指挥的原则，因为情况是明了的；但是如果该部队或该兵团一旦分散行动，便又适用一般集中、具体分散的原则，因为具体的情况无从明了。   
　　应该集中的不集中，在上者叫做失职，在下者叫做专擅，这是在任何上下级关系上特别是在军事关系上所不许可的。应该分散的不分散，在上者叫做包办，在下者叫做无自动性，这也是在任何上下级关系上特别是在游击战争的指挥关系上所不许可的。只有上述的原则，才是正确地解决这个问题的方针。   
  
------------------  
　　注　　释   
　　〔1〕长白山是中国东北边境的山脉。一九三一年九一八事变后，中国共产党领导的抗日游击队，与其他自发的抗日武装以及活动在东北地区的朝鲜共产主义者一道，曾一度在长白山区开展和坚持游击战争。   
　　〔2〕五台山是山西东北部延至河北边界的山脉。一九三七年十月，以八路军一一五师一部为主以五台山为依托，开展抗日游击战争，建立晋察冀抗日根据地。一九三八年一月，成立晋察冀边区临时行政委员会。后来晋察冀边区扩大到同蒲路以东，正太路、德石路以北，张家口、多伦、宁城、锦州以南，渤海以西的绝大部分地区。   
　　〔3〕太行山是山西、河北、河南三省交界的山脉。一九三七年十月，八路军一二九师向太行山区挺进；十一月开始创立以太行山为依托的晋东南抗日根据地，同时分兵向冀南、豫北的边界和冀西发展。一九三八年四月成立晋冀豫军区，后又相继开辟冀南、冀鲁豫抗日根据地，一九四一年建立了晋冀鲁豫边区政府。后来边区发展到东起津浦路，西至同蒲路，北起正太路、德石路，南至黄河的绝大部分地区。   
　　〔4〕泰山在山东中部，是泰沂山脉的主峰之一。一九三七年冬至一九三八年春，中国共产党领导的游击队依托泰沂山区，发动抗日武装起义，开展游击战争，为创建鲁中抗日根据地奠定了基础。   
　　〔5〕燕山是河北省东北部的山脉。一九三八年夏，八路军第四纵队进入冀东的燕山地区。中共冀热边特委在八路军第四纵队的配合下，发动和领导了冀东二十一县和唐山矿区的工人农民抗日武装大起义。一九三九年后逐步建立了冀东抗日根据地，后来发展成为冀热辽抗日根据地。   
　　〔6〕茅山在江苏省南部。一九三八年四月，新四军先遣支队开始向苏南敌后出动，实行战略侦察。六月和七月，新四军第一、第二支队先后从安徽南部进入苏南，发动抗日游击战争，开创以茅山山区为中心的苏南抗日根据地。   
　　〔7〕抗日战争发展的经验，证明了平原地区能够建立长期的而且在许多地方能够成为固定的根据地，这是由于地区的广大，人口的众多，共产党政策的正确，人民动员的普遍和敌人兵力的不足等等条件所决定的。毛泽东随后在具体的指示中即把这点加以明确地肯定了。   
　　〔8〕围棋是中国的一种很古老的棋。双方的棋子互相包围，一方的一个或一群子被对方所包围，就被“吃”掉。但如果在被包围的一群子中保有必要的空格（“眼”），这群子就是“活”的，不被“吃”掉。   
　　〔9〕公元前三五四年，魏军围攻赵国都城邯郸（今河北省邯郸市西南）。第二年，齐国国君命田忌、孙膑率军救赵。孙膑认为魏军精锐在赵，内部空虚，主张引兵迅速进攻魏都，迫使魏军弃赵自救。田忌采纳了孙膑的意见。魏军果然回救本国。齐军乘魏军疲惫，在桂陵（今河南省长垣县西北）设伏袭击，大败魏军，赵国之围也随着解除。后来中国的军事家就用“围魏救赵”来说明类似的战法。   